package pt.caf_pbs.schooldiskapi.dao;

import pt.caf_pbs.schooldiskapi.mock.MockData;
import pt.caf_pbs.schooldiskapi.model.School;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

import static java.nio.file.StandardOpenOption.CREATE;

/**
 * Created by paulo on 17-03-2017.
 */
public class FilesOperation {
    static final String SCHOOL_FILE ="school.dat";

    public static School loadSchool(){
        School school = new School();
        Path file = Paths.get(SCHOOL_FILE);
        try {
            ObjectInputStream o = new ObjectInputStream(new FileInputStream(file.toString()));
            school = (School)o.readObject();
            o.close();
        }
        catch (Exception e) {
            System.out.println(e);
            MockData mock = new MockData();
            mock.generateData(school);
            school.setName("ISEP");
        }
        return school;
    }

    public static School restoreSchool(){
        School school = new School();
        MockData mock = new MockData();
        mock.generateData(school);
        school.setName("ISEP");
        storeSchool(school);
        return school;
    }

    public static void storeSchool(School school) {
        Path file = Paths.get(SCHOOL_FILE);
        try{
            ObjectOutputStream o = new ObjectOutputStream(Files.newOutputStream(file, CREATE));
            o.writeObject(school);
            o.close();
        }
        catch (Exception e){
            System.out.println(e);
        }
    }
    public static void printStudentCertificate(int number, String data){
        String fileName ="certificate_"+number+".txt";
        Path file = Paths.get(fileName);
        OutputStream output = null;
        try {
            output = new BufferedOutputStream(Files.newOutputStream(file, CREATE));
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output));
            writer.write(data,  0, data.length());
            writer.flush();
            writer.close();
        }
        catch(Exception e){
            System.out.println("Message: " + e);
        }
    }

}
